#
#  Plik:  bc_experiments.py
#
#  Różne modele przetwarzające zestaw Breast Cancer (r4).
#
#  RTK, 02.06.2018
#  Ostatnia aktualizacja:  02.06.2018
#
###############################################################

import numpy as np
from sklearn.neighbors import NearestCentroid
from sklearn.neighbors import KNeighborsClassifier
from sklearn.naive_bayes import GaussianNB, MultinomialNB
from sklearn.tree import DecisionTreeClassifier
from sklearn.ensemble import RandomForestClassifier
from sklearn.svm import SVC

def run(x_train, y_train, x_test, y_test, clf):
    """Uczenie i testowanie"""

    clf.fit(x_train, y_train)
    print("    Ocena = %0.4f" % clf.score(x_test, y_test))
    print()


def main():
    """Przeprowadza eksperymenty za pomocą zestawu Breast Cancer"""

    #  Wczytuje pierwotne dane i dzieli je na zbiory uczący/testowy
    x = np.load("../data/breast/bc_features_standard.npy")
    y = np.load("../data/breast/bc_labels.npy")

    np.random.seed(12345)
    idx = np.argsort(np.random.random(y.shape[0]))
    x = x[idx]
    y = y[idx]
    np.random.seed()

    N = 455
    x_train = x[:N];  x_test = x[N:]
    y_train = y[:N];  y_test = y[N:]

    #  Najbliższy centroid
    print("Najbliższy centroid:")
    run(x_train, y_train, x_test, y_test, NearestCentroid())

    #  k-NN
    print("Klasyfikator k-NN (k=3):")
    run(x_train, y_train, x_test, y_test, KNeighborsClassifier(n_neighbors=3))
    print("Klasyfikator k-NN (k=7):")
    run(x_train, y_train, x_test, y_test, KNeighborsClassifier(n_neighbors=7))

    #  Naiwny klasyfikator Bayesa
    print("Naiwny klasyfikator Bayesa (gaussowski):")
    run(x_train, y_train, x_test, y_test, GaussianNB())

    #  Drzewo decyzyjne
    print("Drzewo decyzyjne:")
    run(x_train, y_train, x_test, y_test, DecisionTreeClassifier())

    #  Las losowy
    print("Las losowy (estimators=5):")
    run(x_train, y_train, x_test, y_test, RandomForestClassifier(n_estimators=5))
    print("Las losowy (estimators=50):")
    run(x_train, y_train, x_test, y_test, RandomForestClassifier(n_estimators=50))

    #  Liniowa maszyna SVM
    print("Maszyna SVM (liniowa, C=1.0):")
    run(x_train, y_train, x_test, y_test, SVC(kernel="linear", C=1.0))

    #  Maszyna SVM (RBF): gamma = 1/30 = 0.03333
    print("Maszyna SVM (RBF, C=1.0, gamma=0.03333):")
    run(x_train, y_train, x_test, y_test, SVC(kernel="rbf", C=1.0, gamma=0.03333))


main()

