#
#  Plik:  mnist_nn_experiments_retrain.py
#
#  Zmniejszony zestaw MNIST + sieć neuronowa (R6).
#
#  RTK, 15.10.2018
#  Ostatnia aktualizacja:  15.10.2018
#
###############################################################

import numpy as np
import time
from sklearn.neural_network import MLPClassifier 


def run(x_train, y_train, x_test, y_test, clf):
    """Uczenie i testowanie"""

    s = time.time()
    clf.fit(x_train, y_train)
    e = time.time()-s
    loss = clf.loss_
    return [clf.score(x_test, y_test), loss, e]


def nn():
    """Inicjalizacja sieci"""

    return MLPClassifier(solver="sgd", verbose=False, tol=1e-8,
            nesterovs_momentum=False, early_stopping=False,
            learning_rate_init=0.001, momentum=0.9, max_iter=50,
            hidden_layer_sizes=(1000,500), activation="relu",
            batch_size=64)


def main():
    """Przeprowadza eksperymenty na zbiorze MNIST"""

    #  Skalowany wektor danych MNIST: [0,1)
    x_train = np.load("../data/mnist/mnist_train_vectors.npy").astype("float64")/256.0
    y_train = np.load("../data/mnist/mnist_train_labels.npy")
    x_test = np.load("../data/mnist/mnist_test_vectors.npy").astype("float64")/256.0
    y_test = np.load("../data/mnist/mnist_test_labels.npy")

    #  Próby zbioru uczącego
    N = 20000
    x = x_train[:N]
    y = y_train[:N]
    xt= x_test[:N]
    yt= y_test[:N]

    M = 20
    scores = np.zeros(M)
    losses = np.zeros(M)
    for i in range(M):
        s,l,e = run(x, y, xt, yt, nn())
        print("%03i: Ocena = %0.5f, Strata = %0.5f" % (i,s,l))
        scores[i] = s
        losses[i] = l

    print()
    print("Oceny:  min, max, średnia+/-SE: %0.5f, %0.5f, %0.5f +/- %0.5f" % \
        (scores.min(), scores.max(), scores.mean(), scores.std()/np.sqrt(scores.shape[0])))
    print("Strata  :  min, max, średnia+/-SE: %0.5f, %0.5f, %0.5f +/- %0.5f" % \
        (losses.min(), losses.max(), losses.mean(), losses.std()/np.sqrt(losses.shape[0])))
    print()


main()

