#
#  Plik:  mnist_nn_experiments_30k_momentum.py
#
#  RTK, 19.10.2018
#  Ostatnia aktualizacja:  17.12.2019
#
###############################################################

import os
import time
import numpy as np
import matplotlib.pylab as plt
from sklearn.neural_network import MLPClassifier


def epoch(x_train, y_train, x_test, y_test, clf):
    """Wyniki dla jednej epoki"""

    clf.fit(x_train, y_train)
    train_loss = clf.loss_
    train_err = 1.0 - clf.score(x_train, y_train)
    val_err = 1.0 - clf.score(x_test, y_test)
    clf.warm_start = True
    return [train_loss, train_err, val_err]


def run(x_train, y_train, x_test, y_test, clf, max_iter):
    """Uczenie i testowanie"""

    train_loss = []
    train_err = []
    val_err = []

    clf.max_iter = 1  # one epoch at a time
    for i in range(max_iter):
        tl, terr, verr = epoch(x_train, y_train, x_test, y_test, clf)
        train_loss.append(tl)
        train_err.append(terr)
        val_err.append(verr)
        print("    %4d: val_err = %0.5f" % (i, val_err[-1]))

    return [train_loss, train_err, val_err]


def main():
    """Wykresy funkcji straty dla zbiorów uczącego i walidacyjnego."""

    os.system("rm -rf mnist_nn_experiments_momentum")
    os.system("mkdir mnist_nn_experiments_momentum")

    #  Skalowany wektor wariantów MNIST: [0,1)
    x_train = np.load("../data/mnist/mnist_train_vectors.npy").astype("float64")/256.0
    y_train = np.load("../data/mnist/mnist_train_labels.npy")
    x_test = np.load("../data/mnist/mnist_test_vectors.npy").astype("float64")/256.0
    y_test = np.load("../data/mnist/mnist_test_labels.npy")

    #  Zmniejsza rozmiar danych uczących
    x_train = x_train[:30000]
    y_train = y_train[:30000]

    #  Wartości momentum
    colors= ['k','r','b','g','c','m']
    momentum = [0.0,0.3,0.5,0.7,0.9,0.99]
    epochs = 100

    for k,m in enumerate(momentum):
        nn = MLPClassifier(solver="sgd", verbose=False, tol=0,
                nesterovs_momentum=False,
                early_stopping=False,
                learning_rate_init=0.01,
                momentum=m,
                hidden_layer_sizes=(100,50),
                activation="relu",
                alpha=0.0001,
                learning_rate="constant",
                batch_size=64,
                max_iter=1)
        print("momentum = %0.1f" % m)
        train_loss, train_err, val_err = run(x_train, y_train, x_test, y_test, nn, epochs)
        print("    Końcowe: błąd dla zbioru testowego: %0.5f, walidacyjnego: %0.5f"  % \
            (train_err[-1], val_err[-1]))
        print()
        if (k==0):
            plt.plot(val_err, color=colors[k], linewidth=3)
        else:
            plt.plot(val_err, color=colors[k])
        np.save("mnist_nn_experiments_momentum/train_error_30k_%0.2f.npy" % m, train_err)
        np.save("mnist_nn_experiments_momentum/train_loss_30k_%0.2f.npy" % m, train_loss)
        np.save("mnist_nn_experiments_momentum/val_error_30k_%0.2f.npy" % m, val_err)
    plt.xlabel("Epoki")
    plt.ylabel("Błąd")
    plt.tight_layout()
    pname = "mnist_nn_experiments_momentum/mnist_nn_experiments_30k_momentum_plot.png"
    plt.savefig(pname, format="png", dpi=600)
    plt.close()


if (__name__ == "__main__"):
    main()

