import static com.objectmentor.utilities.args.ArgsException.ErrorCode.*;

public class ArgsException extends Exception {
  private char errorArgumentId = '\0';
  private String errorParameter = null;
  private ErrorCode errorCode = OK;

  public ArgsException() {}

  public ArgsException(String message) {super(message);}

  public ArgsException(ErrorCode errorCode) {
    this.errorCode = errorCode;
  }

  public ArgsException(ErrorCode errorCode, String errorParameter) {
    this.errorCode = errorCode;
    this.errorParameter = errorParameter;
  }

  public ArgsException(ErrorCode errorCode,
                       char errorArgumentId, String errorParameter) {
    this.errorCode = errorCode;
    this.errorParameter = errorParameter;
    this.errorArgumentId = errorArgumentId;
  }

  public char getErrorArgumentId() {
    return errorArgumentId;
  }

  public void setErrorArgumentId(char errorArgumentId) {
    this.errorArgumentId = errorArgumentId;
  }

  public String getErrorParameter() {
    return errorParameter;
  }

  public void setErrorParameter(String errorParameter) {
    this.errorParameter = errorParameter;
  }

  public ErrorCode getErrorCode() {
    return errorCode;
  }

  public void setErrorCode(ErrorCode errorCode) {
    this.errorCode = errorCode;
  }

  public String errorMessage() {
    switch (errorCode) {
      case OK:
        return "TILT: Nie dostpne.";
      case UNEXPECTED_ARGUMENT:
      return String.format("Nieoczekiwany argument -%c.", errorArgumentId);
      case MISSING_STRING:
      return String.format("Nie mona znale parametru znakowego dla -%c.",
                           errorArgumentId);
      case INVALID_INTEGER:
      return String.format("Argument -%c oczekuje liczby cakowitej, a by '%s'.",
                            errorArgumentId, errorParameter);
      case MISSING_INTEGER:
        return String.format("Nie mona znale parametru cakowitego dla -%c.",
                             errorArgumentId);
      case INVALID_DOUBLE:
        return String.format("Argument -%c oczekuje liczby double a by '%s'.",
                              errorArgumentId, errorParameter);
      case MISSING_DOUBLE:
        return String.format("Nie mona znale parametru double dla -%c.",
                             errorArgumentId);
      case INVALID_ARGUMENT_NAME:
        return String.format("'%c' nie jest prawidow nazw argumentu.",
                             errorArgumentId);
      case INVALID_ARGUMENT_FORMAT:
        return String.format("'%s' nie jest prawidowym formatem argumentu.",
                             errorParameter);
    }
    return "";
  }
  
  public enum ErrorCode {
  OK, INVALID_ARGUMENT_FORMAT, UNEXPECTED_ARGUMENT, INVALID_ARGUMENT_NAME,
  MISSING_STRING,
  MISSING_INTEGER, INVALID_INTEGER,
  MISSING_DOUBLE, INVALID_DOUBLE}
}