/**
 * Klasa ta generuje liczby pierwsze do okrelonego przez uytkownika
 * maksimum. Uytym algorytmem jest sito Eratostenesa.
 * <p>
 * Eratostenes z Cyrene, urodzony 276 p.n.e. w Cyrene, Libia --
 * zmar 194 w Aleksandrii. Pierwszy czowiek, ktry obliczy
 * obwd Ziemi. Znany rwnie z prac nad kalendarzem 
 * z latami przestpnymi i prowadzenia biblioteki w Aleksandrii.
 * <p>
 * Algorytm jest dosy prosty. Mamy tablic liczby cakowitych
 * zaczynajcych si od 2. Wykrelamy wszystkie wielokrotnoci 2. Szukamy
 * nastpnej niewykrelonej liczby i wykrelamy wszystkie jej wielokrotnoci.
 * Powtarzamy do momentu osignicia pierwiastka kwadratowego z maksymalnej wartoci.
 *
 * @author Alphonse
 * @version 13 Feb 2002 atp
*/
import java.util.*;

  public class GeneratePrimes
  {
  /**
  * @param maxValue jest limitem generacji.
  */

  public static int[] generatePrimes(int maxValue)
  {
    if (maxValue >= 2) // jedyny prawidowy przypadek
    {
      // deklaracje
      int s = maxValue + 1; // rozmiar tablicy
      boolean[] f = new boolean[s];
      int i;
      // inicjalizacja tablicy wartociami true.
      for (i = 0; i < s; i++)
        f[i] = true;
      // usuwanie znanych liczb nie bdcych pierwszymi
      f[0] = f[1] = false;
      // sito
      int j;
      for (i = 2; i < Math.sqrt(s) + 1; i++)
      {
        if (f[i]) // jeeli i nie jest wykrelone, wykrelamy jego wielokrotnoci.
        {
          for (j = 2 * i; j < s; j += i)
            f[j] = false; // wielokrotnoci nie s pierwsze
        }
      }

      // ile mamy liczb pierwszych?
      int count = 0;
      for (i = 0; i < s; i++)
      {
        if (f[i])
          count++; // licznik trafie.
      }

      int[] primes = new int[count];

      // przeniesienie liczb pierwszych do wyniku
      for (i = 0, j = 0; i < s; i++)
      {
        if (f[i]) // jeeli pierwsza
          primes[j++] = i;
      }
      return primes; // zwracamy liczby pierwsze
    }
    else // maxValue < 2
      return new int[0]; // zwracamy pust tablic jeeli niewaciwe dane wejciowe.
    }
}
