public class ArgsExceptionTest extends TestCase {
  public void testUnexpectedMessage() throws Exception {
    ArgsException e =
      new ArgsException(ArgsException.ErrorCode.UNEXPECTED_ARGUMENT,
                        'x', null);
    assertEquals("Argument -x nieoczekiwany.", e.errorMessage());
  }

  public void testMissingStringMessage() throws Exception {
    ArgsException e = new ArgsException(ArgsException.ErrorCode.MISSING_STRING,
                                        'x', null);
    assertEquals("Nie mona znale parametru znakowego dla -x.", e.errorMessage());
  }

  public void testInvalidIntegerMessage() throws Exception {
    ArgsException e =
    new ArgsException(ArgsException.ErrorCode.INVALID_INTEGER,
                      'x', "Czterdzieci dwa");
    assertEquals("Argument -x oczekuje liczby cakowitej 'Czterdzieci dwa'.",
    e.errorMessage());
  }

  public void testMissingIntegerMessage() throws Exception {
    ArgsException e =
      new ArgsException(ArgsException.ErrorCode.MISSING_INTEGER, 'x', null);
      assertEquals("Nie mona znale parametru cakowitego dla -x.", e.errorMessage());
  }

  public void testInvalidDoubleMessage() throws Exception {
    ArgsException e = new ArgsException(ArgsException.ErrorCode.INVALID_DOUBLE,
                                        'x', "Czterdzieci dwa");
    assertEquals("Argument -x oczekuje liczby double a by 'Czterdzieci dwa'.",
    e.errorMessage());
  }

  public void testMissingDoubleMessage() throws Exception {
    ArgsException e = new ArgsException(ArgsException.ErrorCode.MISSING_DOUBLE,
                                        'x', null);
    assertEquals("Nie mona znale parametru double dla -x.", e.errorMessage());
  }
}