# coding: utf-8
class UserNotFoundError(Exception):
    """Zgłoszenie wyjątku, gdy użytkownik nie zostanie znaleziony."""
    def __init__(self, message=None, errors=None):
        # Wywołanie konstruktora klasy bazowej z wymaganymi argumentami.
        super().__init__(message)
        self .errors = errors

def get_user_info(user_obj):
    """Odczytanie danych użytkownika z bazy."""
    user = get_user_from_db(user_obj)
    if not user:
        raise UserNotFoundException(f"Brak użytkownika o identyfikatorze {user_obj.id}")

get_user_info(user_obj)
