# coding: utf-8
import functools
class ValidateParameters:
    def __init__(self, func):
        functools.update_wrapper(self, func)
        self.func = func
    def __call__(self, *parameters):
        if any([isinstance(item, int) for item in parameters]):
            raise TypeError("Parametrem musi być ciąg znaków!")
        else:
            return self.func(*parameters)
@ValidateParameters
def join_strings(*string_list):
    return "".join(string_list)
print(join_strings("a", "n", "b"))
print(join_strings("a", 1, "c"))