﻿using NUnit.Framework;
using System;
using System.IO;

namespace CH06_FailPassRefactor
{
    [TestFixture]
    public class UnitTests
    {
        // Pseudokod.
        // [1] Wywołanie metody w celu logowania wyjątku.
        [Test]
        public void LogException()
        {
            var logger = new Logger();
            var logFileName = logger.Log(new ArgumentException("Argument nie może mieć wartości null"));
            Assert.Pass();
        }
        // [2] Zbudowanie tekstu do zalogowania zawierającego 
        // wszystkie wyjątki wewnętrzne.
        // [3] Zapisanie do pliku tekstu ze znacznikiem czasowym.
        private Exception GetException()
        {
            return new Exception(
                "Wyjątek: Wyjątek główny.",
                new Exception(
                    "Wyjątek: Wyjątek wewnętrzny.",
                    new Exception("Wyjątek: Wewnętrzny wyjątek wewnętrznego wyjątku":
                )
            );
        }

        [Test]
        public void CheckFileExists()
        {
            var logger = new Logger();
            var logFile = logger.Log(GetException());
            FileAssert.Exists(logFile);
        }

        [Test]
        public void ContainsMessage()
        {
            var logger = new Logger();
            var logFile = logger.Log(GetException());
            var msg = File.ReadAllText(logFile);
            Assert.IsTrue(msg.Contains("Wyjątek: Wewnętrzny wyjątek wewnętrznego wyjątku"));
        }
    }
}
