﻿using System;

/// <summary>
/// Przestrzeń nazw CH3.Core.Security zawiera podstawowe typy używane w celu 
/// implementacji mechanizmów zabezpieczeń aplikacji.
/// </summary>
namespace CH3.Core.Security
{
    /// <summary>
    /// Dostarcza dostępnych opcji kryptograficznych.
    /// </summary>
    [Flags]
    public enum SecurityAlgorithm
    {
        /// <summary>
        /// Szyfrowanie AES
        /// </summary>
        Aes,
        /// <summary>
        /// Szyfrowanie AESCNG
        /// </summary>
        AesCng,
        /// <summary>
        /// Szyfrowanie MD5
        /// </summary>
        MD5,
        /// <summary>
        /// Szyfrowanie SHA256
        /// </summary>
        SHA256
    }
}

