﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace CH08_ThreadPool
{
    class Program
    {
        static void Main(string[] args)
        {
            //UsingTaskParallelLibrary();
            //UsingTaskParallelLibraryFor();
            ThreadPoolQueueUserWorkItem();
        }

        private static void UsingTaskParallelLibrary()
        {
            Message($"Metoda UsingTaskParallelLibrary rozpoczęła działanie: Thread Id = ({Thread.CurrentThread.ManagedThreadId})");
            Parallel.Invoke(MethodOne, MethodTwo, MethodThree);
            Message("Metoda UsingTaskParallelLibrary zakończyła działanie.");
        }

        private static void UsingTaskParallelLibraryFor()
        {
            Message($"Metoda UsingTaskParallelLibraryFor rozpoczęła działanie: Thread Id = ({Thread.CurrentThread.ManagedThreadId})");
            Parallel.For(0, 1000, X => Method());
            Message("Metoda UsingTaskParallelLibraryFor zakończyła działanie.");
        }

        private static void ThreadPoolQueueUserWorkItem()
        {
            ThreadPool.QueueUserWorkItem(WaitCallbackMethod);
            Message("Główny wątek wykonuje pewną pracę, po czym przechodzi do stanu uśpienia.");
            Thread.Sleep(1000);
            Message("Główny wątek kończy działanie.");
        }

        private static void WaitCallbackMethod(Object _)
        {
            Message("Witaj z metody WaitCallBackMethod!");
        }

        private static void Method()
        {
            Message($"Wykonano metodę Method: Thread Id({Thread.CurrentThread.ManagedThreadId})");
        }

        private static void MethodOne()
        {
            Message($"Wykonano metodę MethodOne: Thread Id({Thread.CurrentThread.ManagedThreadId})");
        }

        private static void MethodTwo()
        {
            Message($"Wykonano metodę MethodTwo: Thread Id({Thread.CurrentThread.ManagedThreadId})");
        }

        private static void MethodThree()
        {
            Message($"Wykonano metodę MethodThree: Thread Id({Thread.CurrentThread.ManagedThreadId})");
        }

        private static void Message(string message)
        {
            Console.WriteLine(message);
        }
    }
}
