using NUnit.Framework;
using CH06_RhinoMocks;
using Rhino.Mocks;

namespace CH06_RhinoMocks.Tests
{
    [TestFixture]
    public class Tests
    {
        private MockRepository mocks = new MockRepository();

        [Test]
        public void CheckGetMessagePassesWithMock()
        {
            // Aranacja
            DataManager manager = new DataManager();
            DataStore<string> mockDataStore = mocks.DynamicMock<DataStore<string>>();
            // Dziaanie
            Expect.Call(mockDataStore.Item).PropertyBehavior();
            mocks.ReplayAll();
            manager.SetDataSource(mockDataStore);
            manager.LoadDataStore("Witaj, wiecie! Jak Ci si podoba framework Rhino Mocks?");
            // Asercja
            Assert.AreEqual("Witaj, wiecie! Jak Ci si podoba framework Rhino Mocks?", manager.GetMessage());
            mocks.VerifyAll();
        }
    }
}
