﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace CH08_Deadlocks
{
    class Program
    {
        static object _object1 = new object();
        static object _object2 = new object();

        private static void Thread1Method()
        {
            Console.WriteLine("Metoda Thread1Method: początek metody Thread1Method.");
            lock (_object1)
            {
                Console.WriteLine("Metoda Thread1Method: Zablokowała obiekt _object1. Przechodzi do uśpienia...");
                Thread.Sleep(1000);
                Console.WriteLine("Metoda Thread1Method: Wybudziła się z uśpienia.");
                lock (_object2)
                {
                    Console.WriteLine("Metoda Thread1Method: Zablokowała obiekt _object2.
                }
                Console.WriteLine("Metoda Thread1Method: Zwolniła obiekt _object2.");
            }
            Console.WriteLine("Metoda Thread1Method: Zwolniła obiekt _object1.");
        }

        private static void Thread2Method()
        {
            Console.WriteLine("Metoda Thread2Method: początek metody Thread1Method.");
            lock (_object2)
            {
                Console.WriteLine("Metoda Thread2Method: Zablokowała obiekt _object2. Przechodzi do uśpienia...");
                Thread.Sleep(1000);
                Console.WriteLine("Metoda Thread2Method: Wybudziła się z uśpienia.");
                lock (_object1)
                {
                    Console.WriteLine("Metoda Thread2Method: Zablokowała obiekt _object1.
                }
                Console.WriteLine("Metoda Thread2Method: Zwolniła obiekt _object1.");
            }
            Console.WriteLine("Metoda Thread2Method: Zwolniła obiekt _object2.");
        }

        private static void DeadlockNoRecovery()
        {
            Thread thread1 = new Thread((ThreadStart)Thread1Method);
            Thread thread2 = new Thread((ThreadStart)Thread2Method);

            thread1.Start();
            thread2.Start();

            Console.WriteLine("Naciśnij dowolny klawisz, aby zakończyć program.");
            Console.ReadKey();
        }

        static void Main()
        {
            // DeadlockNoRecovery();
            DeadlockWithRecovery();
        }

        private static void DeadlockWithRecovery()
        {
            Thread thread4 = new Thread((ThreadStart)Thread4Method);
            Thread thread5 = new Thread((ThreadStart)Thread5Method);

            thread4.Start();
            thread5.Start();

            Console.WriteLine("Naciśnij dowolny klawisz, aby zakończyć program.");
            Console.ReadKey();
        }

        private static void Thread4Method()
        {
            Console.WriteLine("Metoda Thread4Method: Zablokowała obiekt _object1. Przechodzi do uśpienia...");
            Thread.Sleep(1000);
            Console.WriteLine("Metoda Thread4Method: Wybudziła się z uśpienia.");
            if (!Monitor.TryEnter(_object1))
            {
                Console.WriteLine("Metoda Thead4Method: Nieudana próba zablokowania obiektu _object1.");
                return;
            }
            try
            {
                if (!Monitor.TryEnter(_object2))
                {
                    Console.WriteLine("Metoda Thread4Method: Nieudana próba zablokowania obiektu _object2.");
                    return;
                }
                try
                {
                    Console.WriteLine("Metoda Thread4Method: Korzysta z obiektu _object2.");
                }
                finally
                {
                    Monitor.Exit(_object2);
                    Console.WriteLine("Metoda Thread4Method: Zwolniła blokadę obiektu _object2.");
                }
            }
            finally
            {
                Monitor.Exit(_object1);
                Console.WriteLine("Metoda Thread4Method: Zwolniła blokadę obiektu _object2.");
            }
        }

        private static void Thread5Method()
        {
            Console.WriteLine("Metoda Thread5Method: Zablokowała obiekt _object2. Przechodzi do uśpienia...");
            Thread.Sleep(1000);
            Console.WriteLine("Metoda Thread5Method: Wybudziła się z uśpienia.");
            if (!Monitor.TryEnter(_object2))
            {
                Console.WriteLine("Metoda Thead5Method: Nieudana próba zablokowania obiektu _object2.");
                return;
            }
            try
            {
                if (!Monitor.TryEnter(_object1))
                {
                    Console.WriteLine("Metoda Thread5Method: Nieudana próba zablokowania obiektu _object1.");
                    return;
                }
                try
                {
                    Console.WriteLine("Metoda Thread5Method: Korzysta z obiektu _object1.");
                }
                finally
                {
                    Monitor.Exit(_object1);
                    Console.WriteLine("Metoda Thread5Method: Zwolniła blokadę obiektu _object1.");
                }
            }
            finally
            {
                Monitor.Exit(_object2);
                Console.WriteLine("Metoda Thread5Method: Zwolniła blokadę obiektu _object2.");
            }
        }
    }
}
