﻿using System;
using CH14_DesignPatterns.BehavioralDesignPatterns.ChainOfResponsibility;
using CH14_DesignPatterns.BehavioralDesignPatterns.Command;
using CH14_DesignPatterns.CreationalDesignPatterns.AbstractFactory;
using CH14_DesignPatterns.CreationalDesignPatterns.Builder;
using CH14_DesignPatterns.CreationalDesignPatterns.FactoryMethod;
using CH14_DesignPatterns.CreationalDesignPatterns.Prototype;
using CH14_DesignPatterns.CreationalDesignPatterns.Singleton;
using CH14_DesignPatterns.StructuralDesignPatterns.Bridge;
using CH14_DesignPatterns.StructuralDesignPatterns.Composite;
using CH14_DesignPatterns.StructuralDesignPatterns.Facade;
using ConcreteProduct = CH14_DesignPatterns.CreationalDesignPatterns.AbstractFactory.ConcreteProduct;

namespace CH14_DesignPatterns
{
    class Program
    {
        static void Main(string[] args)
        {
            //RunCreationalExamples();
            RunStructuralExamples();

            Console.WriteLine("Naciśnij dowolny klawisz, aby zakończyć program.");
            Console.ReadKey();
        }

        #region Creational Design Pattern Examples

        private static void RunCreationalExamples()
        {
            //AbstractFactoryExample();
            //FactoryMethodExample();
            //SingletonExample();
            //PrototypeExample();
            //BuilderExample();
        }

        private static void AbstractFactoryExample()
        {
            AbstractFactory factory = new ConcreteProduct();
            Client client = new Client(factory);
            client.Run();
        }

        private static void FactoryMethodExample()
        {
            var creator = new ConcreteCreator();
            var product = creator.FactoryMethod();
            Console.WriteLine($"Typ produktu: {product.GetType().Name}");
        }

        private static void SingletonExample()
        {
            var instance1 = Singleton.Instance();
            var instance2 = Singleton.Instance();

            if (instance1.Equals(instance2))
                Console.WriteLine("instance1 i instance2 są tym samym egzemplarzem klasy Singleton.");
        }

        private static void PrototypeExample()
        {
            StringConcatenation.UsingThePlusOperator();
            StringConcatenation.UsingTheStringBuilder();
            StringConcatenation.PrintTimeDifference();
            //var prototype = new ConcretePrototype("Klon 1");
            //var clone = (ConcretePrototype)prototype.Clone();
            //Console.WriteLine($"Identyfikator klona: {clone.Id}");
        }

        private static void BuilderExample()
        {
            var director = new Director();
            var builder = new ConcreteBuilder();
            director.Build(builder);
            var product = builder.GetProduct();
            product.PrintPartsList();
        }

        #endregion

        #region Structural Design Pattern Examples

        private static void RunStructuralExamples()
        {
            //BridgeExample();
            //CompositeExample();
            //FacadeExample();
            FlyweightExample();
            //ChainOfResponsibilityExample();
            //CommandExample();
        }

        private static void BridgeExample()
        {
            var abstraction = new RefinedAbstraction
            {
                Implementor = new ConcreteImplementor()
            };
            abstraction.Operation();
        }

        private static void CompositeExample()
        {
            var root = new Composite("Klasyfikacja zwierząt ");
            var invertebrates = new Composite("+ Bezkręgowce");
            var vertebrates = new Composite("+ Kręgowce");

            var warmBlooded = new Leaf("-- Stałocieplne ");
            var coldBlooded = new Leaf("-- Zmiennocieplne ");
            var withJointedLegs = new Leaf("-- Stawonogi ");
            var withoutLegs = new Leaf("-- Mięczaki");
            invertebrates.Add(withJointedLegs);
            invertebrates.Add(withoutLegs);

            vertebrates.Add(warmBlooded);
            vertebrates.Add(coldBlooded);

            root.Add(invertebrates);
            root.Add(vertebrates);

            root.PrintName();

        }

        private static void FacadeExample()
        {
            var facade = new Facade();
            facade.SubsystemOneDoWork();
            facade.SubsystemTwoDoWork();
        }

        private static void FlyweightExample()
        {
            var flyweightClient = new StructuralDesignPatterns.Flyweight.Client();
            flyweightClient.ProcessFlyweights();
        }

        private static void ChainOfResponsibilityExample()
        {
            var handlerOne = new ConcreteHandlerOne();
            var handlerTwo = new ConcreteHandlerTwo();

            handlerOne.SetSuccessor(handlerTwo);
            handlerTwo.SetSuccessor(handlerOne);

            handlerOne.HandleRequest("PrintDate");
            handlerOne.HandleRequest("PrintGreeting");
        }

        private static void CommandExample()
        {
            var receiver = new Receiver();
            var command = new ConcreteCommand(receiver);
            var invoker = new Invoker();
            invoker.SetCommand(command);
            invoker.ExecuteCommand();
        }

        #endregion
    }
}
