﻿using System;
using System.Diagnostics;
using System.IO;
using System.Linq;

namespace CH11_Caching
{
    internal class RedisServer : IDisposable
    {
        private Process process;

        private RedisServer(Process process)
        {
            this.process = process;
        }


        public void Dispose()
        {
            if (process != null)
            {
                Console.WriteLine("Zatrzymanie serwera Redis.");
                process.Close();
                process = null;
            }
        }

        public static RedisServer Start()
        {
            if (Process.GetProcessesByName("redis-server").Any())
            {
                Console.WriteLine("Redis uruchomiony.");
            }
            else
            {
                var configFile = Path.GetFullPath("redis.conf");

                Console.WriteLine("Uruchamianie serwera Redis z wykorzystaniem pliku konfiguracyjnego: " + configFile);

                // Zaktualizuj tę ścieżkę, jeśli pakiet Nuget Redis-64 został przywrócony do innej lokalizacji.
                return new RedisServer(Process.Start(
                  Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.UserProfile),
                    ".nuget", "packages", "redis-64", "3.0.503", "tools", "redis-server.exe"),
                  configFile));
            }
            return new RedisServer(null);
        }
    }
}
