﻿using System;
using System.Threading;

namespace CH08_ThreadsIntro
{
    class Program
    {
        private static readonly Mutex _mutex;
        private static readonly Semaphore _semaphore;

        static void Main(string[] args)
        {
            SynchronousProcessing();
            ParallelProcessingUsingForegroundThreads();
            ParallelProcessingUsingBackgroundThreads();
            Console.ReadKey();
        }

        internal static void Message(string message)
        {
            Console.WriteLine(message);
        }

        internal static void ThreadDelay(TimeSpan timeSpan)
        {
            Thread.Sleep(timeSpan);
        }

        private static void SynchronousProcessing()
        {
            Method1();
            Method2();
        }

        private static void ParallelProcessingUsingForegroundThreads()
        {
            var method1Thread = new Thread(Method1);
            var method2Thread = new Thread(Method2);
            method1Thread.Start();
            method2Thread.Start();
        }

        private static void ParallelProcessingUsingBackgroundThreads()
        {
            var method3Thread = new Thread(Method3);
            method3Thread.IsBackground = true;
            method3Thread.Start();
            Console.WriteLine("Główna aplikacja zakończyła działanie.");
        }

        private static void Method1()
        {
            for (var i = 0; i < 10; i++)
            {
                Console.WriteLine($"Metoda Method 1 wykonana: {i}");
                Thread.Sleep(500);
            }
        }

        private static void Method2()
        {
            for (var i = 0; i < 10; i++)
            {
                Console.WriteLine($"Metoda Method 2 wykonana: {i}");
                Thread.Sleep(500);
            }
        }

        private static void Method3()
        {
            Console.WriteLine("Wejście do metody Method 3 ");
            Console.ReadKey();
            Console.WriteLine("Wyjście z metody Method 3 ");
        }



        private static void ForegroundThreadExample()
        {
            var foregroundThread = new Thread(() => {
                Message("Wątek pierwszego planu ");
            });
            foregroundThread.Start();
        }

        private static void BackgroundThreadExample()
        {
            var backgroundThread = new Thread(() =>
            {
                Message("Wątek drugiego planu ");
            })
            {
                IsBackground = true
            };
            backgroundThread.Start();
        }

        private static void ThreadParametersExample()
        {
            int result = 0;
            Thread thread = new Thread(() => { result = Add(1, 2); });
            thread.Start();
            thread.Join();
            Message($"Wynik dodawania 1 do 2 to {result}.");
        }

        private static int Add(int a, int b)
        {
            return a + b;
        }

        private static void MutexExample()
        {
            for (var i = 1; i <= 10; i++)
            {
                var thread = new Thread(ThreadSynchronisationUsingMutex)
                {
                    Name = $"Przykład użycia muteksu. Wątek: {i}"
                };
                thread.Start();
            }
        }

        private static void ThreadSynchronisationUsingMutex()
        {
            try
            {
                _mutex.WaitOne();
                Message($"Do domeny wszedł wątek: {Thread.CurrentThread.Name}");
                Thread.Sleep(500);
                Message($"Domenę opuścił wątek: {Thread.CurrentThread.Name}");
            }
            catch
            {
                _mutex.ReleaseMutex();
            }
        }

        private static void SemaphoreExample()
        {
            for (int i = 1; i <= 10; i++)
            {
                Thread t = new Thread(StartSemaphore);
                t.Start(i);
            }
        }

        private static void StartSemaphore(object id)
        {
            Console.WriteLine($"Obiekt {id} chce uzyskać dostęp do semafora.");
            try
            {
                _semaphore.WaitOne();
                Console.WriteLine($"Obiekt {id} uzyskał dostęp do semafora.");
                Thread.Sleep(1000);
                Console.WriteLine($"Obiekt {id} zwolnił semafor.");
            }
            finally
            {
                _semaphore.Release();
            }
        }
    }
}
