using NUnit.Framework;
using System;
using System.Diagnostics;

namespace CH06_NUnitUnitTesting.Tests
{
    [TestFixture]
    public sealed class Tests : IDisposable
    {
        private static void WriteSeparatorLine()
        {
            Debug.WriteLine("--------------------------------------------------");
        }

        public Tests()
        {
            WriteSeparatorLine();
            Debug.WriteLine("Konstruktor");
        }

        public void Dispose()
        {
            WriteSeparatorLine();
            Debug.WriteLine("Dispose");
        }

        [SetUp]
        public void Setup()
        {
            WriteSeparatorLine();
            Debug.WriteLine("Setup");
            Debug.WriteLine("Ta metoda jest uruchamiana przed uruchomieniem kadej metody testowej.");
        }

        [TearDown]
        public void Teardown()
        {
            WriteSeparatorLine();
            Debug.WriteLine("Teardown");
            Debug.WriteLine("Ta metoda jest uruchomiana po uruchomieniu wszystkich metod testowych. ");
            Debug.WriteLine("Metoda zostanie uruchomiona nawet wtedy, gdy wystpi wyjtek.");
        }

        [OneTimeSetUp]
        public void OneTimeSetup()
        {
            WriteSeparatorLine();
            Debug.WriteLine("OneTimeSetUp");
            Debug.WriteLine("Ta metoda jest uruchomiana raz, przed uruchomieniem jakichkolwiek zdefiniowanych w niej testw.");
        }

        [OneTimeTearDown]
        public void OneTimeTearDown()
        {
            WriteSeparatorLine();
            Debug.WriteLine("OneTimeTearDown");
            Debug.WriteLine("Ta metoda jest uruchomiana raz, po uruchomieniu wszystkich testw w tej klasie.");
            Debug.WriteLine("Metoda zostanie uruchomiona nawet wtedy, gdy wystpi wyjtek.");
        }

        [Test]
        [Order(1)]
        public void Test2()
        {
            WriteSeparatorLine();
            Debug.WriteLine("Test:Test2");
            Debug.WriteLine("Kolejno: 1");
            Assert.Inconclusive("Test 2 ma wynik niejednoznaczny.");
        }

        [Test]
        [Order(0)]
        public void Test1()
        {
            WriteSeparatorLine();
            Debug.WriteLine("Test:Test1");
            Debug.WriteLine("Kolejno: 0");
            Assert.Pass("Test 1 przeszed z migajcymi kolorami.");
        }

        [Test]
        [Order(2)]
        public void Test3()
        {
            WriteSeparatorLine();
            Debug.WriteLine("Test:Test3");
            Debug.WriteLine("Kolejno: 2");
            Assert.Fail("Test 1 nie powid si.");
        }
    }
}
