"""Czysty kod w Pythonie - Rozdział 09: Typowe wzorce projektowe

> Wzorzec Monostat: BORG
"""
from log import logger


class BaseFetcher:
    def __init__(self, source):
        self.source = source


class TagFetcher(BaseFetcher):
    _attributes: dict = {}

    def __init__(self, source):
        self.__dict__ = self.__class__._attributes
        super().__init__(source)

    def pull(self):
        logger.info("pobieranie ze znacznika %s", self.source)
        return f"Tag = {self.source}"


class BranchFetcher(BaseFetcher):
    _attributes: dict = {}

    def __init__(self, source):
        self.__dict__ = self.__class__._attributes
        super().__init__(source)

    def pull(self):
        logger.info("pobieranie z gałęzi %s", self.source)
        return f"Branch = {self.source}"
