"""Czysty kod w Pythonie - Rozdział 09: Typowe wzorce projektowe

> Wzorzec Monostat
"""

from log import logger


class SharedAttribute:
    def __init__(self, initial_value=None):
        self.value = initial_value
        self._name = None

    def __get__(self, instance, owner):
        if instance is None:
            return self
        if self.value is None:
            raise AttributeError(f"{self._name} nigdy nie został ustawiony")
        return self.value

    def __set__(self, instance, new_value):
        self.value = new_value

    def __set_name__(self, owner, name):
        self._name = name


class GitFetcher:

    current_tag = SharedAttribute()
    current_branch = SharedAttribute()

    def __init__(self, tag, branch=None):
        self.current_tag = tag
        self.current_branch = branch

    def pull(self):
        logger.info("poieranie z %s", self.current_tag)
        return self.current_tag
