"""Czysty kod w Pythonie - Rozdział 5: Dekoratory

Uproszczone wywołania dekoratorów z argumentami domyślnymi.
"""
from functools import wraps, partial

DEFAULT_X = 1
DEFAULT_Y = 2


def decorator(function=None, *, x=DEFAULT_X, y=DEFAULT_Y):
    if function is None:
        return partial(
            decorator, x=x, y=y
        )  # również lambda f: decorator(f, x=x, y=y)

    @wraps(function)
    def wrapped():
        return function(x, y)

    return wrapped
