"""Czysty kod w Pythonie - Rozdział 5: Dekoratory

Przykład do pierwszego podrozdziału: dekorator nie pozwala na korzystanie z parametrów.
> Dekoratory funkcji
    - Utworzenie dekoratora, który będzie zastosowany za pomocą funkcji.
    - Implementacja dekoratora jako obiektu.
"""
from functools import wraps

from decorator_function_1 import ControlledException
from log import logger


class Retry:
    def __init__(self, operation):
        wraps(operation)(self)
        self.operation = operation

    def __call__(self, *args, **kwargs):
        last_raised = None
        RETRIES_LIMIT = 3
        for _ in range(RETRIES_LIMIT):
            try:
                return self.operation(*args, **kwargs)
            except ControlledException as e:
                logger.info("próba %s wykonania", self.operation.__qualname__)
                last_raised = e
        raise last_raised


@Retry
def run_operation(task):
    """Uruchomienie operacji przekazanej w task"""
    return task.run()
