"""CCzysty kod w Pythonie - Rozdział 5: Dekoratory

> Podział odpowiedzialności (SoC)..
Podzielenie sprzężonego dekoratora na kilka mniejszych.
"""
import time
from functools import wraps

from log import logger


def log_execution(function):
    @wraps(function)
    def wrapped(*args, **kwargs):
        logger.info("początek działania funkcji %s", function.__qualname__)
        return function(*kwargs, **kwargs)

    return wrapped


def measure_time(function):
    @wraps(function)
    def wrapped(*args, **kwargs):
        start_time = time.time()
        result = function(*args, **kwargs)

        logger.info(
            "działanie funkcji %s zajęło %.2f",
            function.__qualname__,
            time.time() - start_time,
        )
        return result

    return wrapped


@measure_time
@log_execution
def operation():
    time.sleep(3)
    logger.info("uruchomiona funkcja...")
    return 33
