"""Czysty kod w Pythonie - Wydanie drugie
Rozdział 04 - Zasady SOLID

ISP: Zasada segregacji interfejsów
"""

from abc import ABCMeta, abstractmethod


class XMLEventParser(metaclass=ABCMeta):
    @abstractmethod
    def from_xml(xml_data: str):
        """Parsuje zdarzenie ze źródła zapisanego jako reprezentacja XML."""


class JSONEventParser(metaclass=ABCMeta):
    @abstractmethod
    def from_json(json_data: str):
        """Parsuje zdarzenie ze źródła zapisanego w formacie JSON."""


class EventParser(XMLEventParser, JSONEventParser):
    """Parser zdarzeń, który potrafi utworzyć zdarzenie z danych źródłowych 
       w formacie XML lub JSON.
    """

    def from_xml(xml_data):
        pass

    def from_json(json_data: str):
        pass
