"""Czysty kod w Pythonie - Rozdział 5: Dekoratory

> Niepożądane skutki uboczne w dekoratorach
"""

import time
from functools import wraps

from log import logger


def traced_function_wrong(function):
    """Przykład źle zdefiniowanego dekoratora."""
    logger.info("started execution of %s", function)
    start_time = time.time()

    @wraps(function)
    def wrapped(*args, **kwargs):
        result = function(*args, **kwargs)
        logger.info(
            "działanie funkcji %s zajęło %.2fs", function, time.time() - start_time
        )
        return result

    return wrapped


@traced_function_wrong
def process_with_delay(callback, delay=0):
    logger.info("oczekiwanie(%d)", delay)
    return callback


def traced_function(function):
    @wraps(function)
    def wrapped(*args, **kwargs):
        logger.info("początek działania funkcji %s", function)
        start_time = time.time()
        result = function(*args, **kwargs)
        logger.info(
            "działanie funkcji %s zajęło %.2fs", function, time.time() - start_time
        )
        return result

    return wrapped


@traced_function
def call_with_delay(callback, delay=0):
    logger.info("oczekiwanie(%d)", delay)
    return callback
