import unittest
from dynamic import DynamicAttributes


class TestDynamic(unittest.TestCase):
    def test_dynamic_attributes(self):
        dyn = DynamicAttributes("wartość")

        self.assertEqual(dyn.attribute, "wartość")
        self.assertEqual(dyn.fallback_test, "[fallback resolved] test")
        self.assertEqual(getattr(dyn, "coś", "domyślnie"), "domyślnie")
        with self.assertRaisesRegex(AttributeError, ".* nie ma atrybutu \S+"):
            dyn.something_not_found


if __name__ == "__main__":
    unittest.main()
