"""Czysty kod w Pythonie - Rozdział 1: Wprowadzenie, formatowanie kodu i narzędzia

Testy dla przykładów adnotacji

"""
import pytest

from src.annotations import Point, locate


@pytest.mark.parametrize(
    "defined_object,expected",
    (
        (locate, {"latitude": float, "longitude": float, "return": Point}),
        (Point, {"lat": float, "long": float}),
    ),
)
def test_annotations(defined_object, expected):
    """testuje klasę/funkcje pod kątem oczekiwanych adnotacji"""
    assert getattr(defined_object, "__annotations__") == expected
