"""Czysty kod w Pythonie - Rozdział 5: Dekoratory

Dekoratory uniwersalne: stwórz dekoratort, które można zastosowac do kilku
różnych obiektów (np. funkcji, metod, itd.).

"""
from functools import wraps

from log import logger


class DBDriver:
    def __init__(self, dbstring: str) -> None:
        self.dbstring = dbstring

    def execute(self, query: str) -> str:
        return f"query {query} at {self.dbstring}"


def inject_db_driver(function):
    """Ten dekorator konwertuje parametr przez utworzenie egzemplarza ``DBDriver``
    na podstawie ciągu dsn bazy danych.
    """

    @wraps(function)
    def wrapped(dbstring):
        return function(DBDriver(dbstring))

    return wrapped


@inject_db_driver
def run_query(driver):
    return driver.execute("test_function")


class DataHandler:
    """Dekorator w takiej postaci nie zadziała w odniesieniu do metod."""

    @inject_db_driver
    def run_query(self, driver):
        return driver.execute(self.__class__.__name__)
