"""Czysty kod w Pythonie - Rozdział 5: Dekoratory

Dekoratory z parametrami z wykorzystaniem obiektów wywoływalnych
"""
from functools import wraps
from typing import Optional, Sequence

from decorator_function_1 import ControlledException
from log import logger

_DEFAULT_RETRIES_LIMIT = 3


class WithRetry:
    def __init__(
        self,
        retries_limit: int = _DEFAULT_RETRIES_LIMIT,
        allowed_exceptions: Optional[Sequence[Exception]] = None,
    ) -> None:
        self.retries_limit = retries_limit
        self.allowed_exceptions = allowed_exceptions or (ControlledException,)

    def __call__(self, operation):
        @wraps(operation)
        def wrapped(*args, **kwargs):
            last_raised = None
            for _ in range(self.retries_limit):
                try:
                    return operation(*args, **kwargs)
                except self.allowed_exceptions as e:
                    logger.warning(
                        "ponowienie próby %s z powodu %s", operation.__qualname__, e
                    )
                    last_raised = e
            raise last_raised

        return wrapped
