"""Czysty kod Pythonie - Rozdział 8: Testy jednostkowe i refaktoryzacja

> Testy jednostkowe, a projektowanie oprogramowania
"""
import logging
import random

logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)


class MetricsClient:
    """Zewnętrzny klient metryk"""

    def send(self, metric_name, metric_value):
        if not isinstance(metric_name, str):
            raise TypeError("oczekiwany typ str dla parametru metric_name")

        if not isinstance(metric_value, str):
            raise TypeError("oczekiwany typ str dla parametru metric_value")

        logger.info("wysyłam %s = %s", metric_name, metric_value)


class WrappedClient:
    """Obiekt pod naszą kontrolą opakowujący obiekt zewnętrzny."""

    def __init__(self):
        self.client = MetricsClient()

    def send(self, metric_name, metric_value):
        return self.client.send(str(metric_name), str(metric_value))


class Process:
    """Ten sam proces, teraz korzystający z obiektu wrappera."""

    def __init__(self):
        self.client = WrappedClient()

    def process_iterations(self, n_iterations):
        for i in range(n_iterations):
            result = self.run_process()
            self.client.send("iteration.{}".format(i), result)

    def run_process(self):
        return random.randint(1, 100)


if __name__ == "__main__":
    Process().process_iterations(10)
