"""Czysty kod w Pythonie - Rozdział 6: Pełniejsze wykorzystanie obieków dzięki 
deskryptorom

> Różne formy implementacji deskryptorów (``__dict__`` kontra ``weakref``)

  - Problem globalnego stanu
"""


class SharedDataDescriptor:
    def __init__(self, initial_value):
        self.value = initial_value

    def __get__(self, instance, owner):
        if instance is None:
            return self
        return self.value

    def __set__(self, instance, value):
        self.value = value


class ClientClass:
    """
    >>> client1 = ClientClass()
    >>> client1.descriptor
    'pierwsza wartość'

    >>> client2 = ClientClass()
    >>> client2.descriptor
    'pierwsza wartość'

    >>> client2.descriptor = "wartość dla klienta 2"
    >>> client2.descriptor
    'wartość dla klienta 2'

    >>> client1.descriptor
    'wartość dla klienta 2'
    """

    descriptor = SharedDataDescriptor("pierwsza wartość")
