"""Czysty kod w Pythonie - Rozdział 5: Dekoratory

Stosuj kompozycję zamiast dziedziczenia, przykład 2
"""
from dataclasses import dataclass


def _resolver_method(self, attr):
    """Metoda rozwiązywania nazw atrybutów, która zastępuje metodę __getattr__."""
    if attr.startswith("resolve_"):
        *_, actual_attr = attr.partition("resolve_")
    else:
        actual_attr = attr
    try:
        return self.__dict__[actual_attr]
    except KeyError as e:
        raise AttributeError from e


def with_resolver(cls):
    """Ustawia niestandardową metodę resolwera nazw dla klasy."""
    cls.__getattr__ = _resolver_method
    return cls


@dataclass
@with_resolver
class Customer:
    customer_id: str
    name: str
    address: str
