# import pandas, matplotlib, and seaborn
import pandas as pd
import matplotlib.pyplot as plt
pd.set_option('display.width', 80)
pd.set_option('display.max_columns', 7)
pd.set_option('display.max_rows', 200)
pd.options.display.float_format = '{:,.0f}'.format
nls97 = pd.read_csv("dane/nls97.csv")
nls97.set_index("personid", inplace=True)
covidtotals = pd.read_csv("dane/covidtotals.csv", parse_dates=["lastdate"])
covidtotals.set_index("iso_code", inplace=True)

# do a boxplot for SAT verbal
nls97.satverbal.describe()

plt.boxplot(nls97.satverbal.dropna(), labels=['Egzamin SAT — część humanistyczna'])
plt.annotate('Próg wartości odstających', xy=(1.05,780), xytext=(1.15,780), size=7, arrowprops=dict(facecolor='black', headwidth=2, width=0.5, shrink=0.02))
plt.annotate('Trzeci kwartyl', xy=(1.08,570), xytext=(1.15,570), size=7, arrowprops=dict(facecolor='black', headwidth=2, width=0.5, shrink=0.02))
plt.annotate('Mediana', xy=(1.08,500), xytext=(1.15,500), size=7, arrowprops=dict(facecolor='black', headwidth=2, width=0.5, shrink=0.02))
plt.annotate('Pierwszy kwartyl', xy=(1.08,430), xytext=(1.15,430), size=7, arrowprops=dict(facecolor='black', headwidth=2, width=0.5, shrink=0.02))
plt.annotate('Próg wartości odstających', xy=(1.05,220), xytext=(1.15,220), size=7, arrowprops=dict(facecolor='black', headwidth=2, width=0.5, shrink=0.02))
plt.title("Wykres pudełkowy wyników egzaminu SAT (część humanistyczna)")
plt.show()

# show some descriptives on weeks worked
weeksworked = nls97.loc[:, ['highestdegree','weeksworked16',\
  'weeksworked17']]
weeksworked.describe()

# do a box plot of weeks worked in 2016 and 2017
plt.boxplot([weeksworked.weeksworked16.dropna(),
  weeksworked.weeksworked17.dropna()],
  labels=['Tygodnie przepracowane w 2016 roku','Tygodnie przepracowane w 2017 roku'])
plt.title("Wykresy pudełkowy liczby przepracowanych tygodni")
plt.tight_layout()
plt.show()

# show some descriptives on coronavirus cases
totvars = ['total_cases','total_deaths','total_cases_pm',\
  'total_deaths_pm']
totvarslabels = ['Liczba przypadków','Liczba zgonów','Liczba przypadków na milion mieszkańców','Liczba zgonów na milion mieszkańców']
covidtotalsonly = covidtotals[totvars]
covidtotalsonly.describe()

# do a box plot of cases and deaths per million
fig, ax = plt.subplots()
plt.title("Wykresy pudełkowe liczby przypadków i zgonów na milion mieszkańców")
ax.boxplot([covidtotalsonly.total_cases_pm,covidtotalsonly.total_deaths_pm],\
  labels=['Liczba przypadków na milion mieszkańców','Liczba zgonów na milion mieszkańców'])
plt.tight_layout()
plt.show()

# show boxplots as separate sub plots on one figure
fig, axes = plt.subplots(2, 2,)
plt.suptitle("Wykresy pudełkowe liczby przypadków i zgonów")
axes = axes.ravel()

for j, ax in enumerate(axes):
  ax.boxplot(covidtotalsonly.iloc[:, j], labels=[totvarslabels[j]])

plt.tight_layout()
fig.subplots_adjust(top=0.94)
plt.show()

