# import pandas, matplotlib, and seaborn
import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns
pd.set_option('display.width', 80)
pd.set_option('display.max_columns', 7)
pd.set_option('display.max_rows', 200)
pd.options.display.float_format = '{:,.0f}'.format
nls97 = pd.read_csv("dane/nls97.csv")
nls97.set_index("personid", inplace=True)
covidtotals = pd.read_csv("dane/covidtotals.csv", parse_dates=["lastdate"])
covidtotals.set_index("iso_code", inplace=True)

# view some descriptive statistics
def gettots(x):
  out = {}
  out['min'] = x.min()
  out['qr1'] = x.quantile(0.25)
  out['med'] = x.median()
  out['qr3'] = x.quantile(0.75)
  out['max'] = x.max()
  out['count'] = x.count()
  return pd.Series(out)

nls97.groupby(['highestdegree'])['weeksworked17'].\
  apply(gettots).unstack()

# do boxplots for weeks worked by highest degree earned
myplt = sns.boxplot('highestdegree','weeksworked17', data=nls97,
  order=sorted(nls97.highestdegree.dropna().unique()))
myplt.set_title("Liczba przepracowanych tygodni w zależności od wykształcenia")
myplt.set_xlabel('Poziom wykształcenia')
myplt.set_ylabel('Liczba tygodni przepracowanych w 2017 roku')
xticklabels = ['0. Brak', '1. Podstawowe', '2. Średnie', '3. Policealne', '4. Licencjat', '5. Magister', '6. Doktor', '7. Profesor']
myplt.set_xticklabels(xticklabels, rotation=60, horizontalalignment='right')
plt.tight_layout()
plt.show()

# view minimum, maximum, median, and first and third quartile values
covidtotals.groupby(['region'])['total_cases_pm'].\
  apply(gettots).unstack()

# do boxplots for cases per million by region
sns.boxplot('total_cases_pm', 'region', data=covidtotals)
sns.swarmplot(y="region", x="total_cases_pm", data=covidtotals, size=2, color=".3", linewidth=0)
plt.title("Liczba przypadków zakażeń na milion mieszkańców w podziale na regiony")
plt.xlabel("Liczba przypadków na milion")
plt.ylabel("Region")
plt.tight_layout()
plt.show()

# show the most extreme value for covid totals
covidtotals.loc[covidtotals.total_cases_pm>=14000,\
  ['location','total_cases_pm']]

# do the same boxplots without the one extreme value in West Asia
sns.boxplot('total_cases_pm', 'region', data=covidtotals.loc[covidtotals.total_cases_pm<14000])
sns.swarmplot(y="region", x="total_cases_pm", data=covidtotals.loc[covidtotals.total_cases_pm<14000], size=3, color=".3", linewidth=0)
plt.title("Liczba przypadków zakażeń na milion mieszkańców\nw podziale na regiony bez wartości ekstremalnych")
plt.xlabel("Liczba przypadków na milion")
plt.ylabel("Region")
plt.tight_layout()
plt.show()

