# import pandas, matplotlib, and seaborn
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import Axes3D
import seaborn as sns
pd.set_option('display.width', 80)
pd.set_option('display.max_columns', 12)
pd.set_option('display.max_rows', 200)
pd.options.display.float_format = '{:,.0f}'.format
landtemps = pd.read_csv("dane/landtemps2019avgs.csv")

# run a scatter plot latitude by avgtemp
plt.scatter(x="latabs", y="avgtemp", data=landtemps)
plt.xlabel("Szerokość geograficzna (N lub S)")
plt.ylabel("Średnia temperatura (stopnie Celsjusza)")
plt.yticks(np.arange(-60, 40, step=20))
plt.title("Średnia temperatura w 2019 roku w zależności od szerokości geograficznej")
plt.show()

# show the high elevation points in a different color
low, high = landtemps.loc[landtemps.elevation<=1000], landtemps.loc[landtemps.elevation>1000]
plt.scatter(x="latabs", y="avgtemp", c="blue", data=low)
plt.scatter(x="latabs", y="avgtemp", c="red", data=high)
plt.legend(('Stacja pomiarowa poniżej 1000 m n.p.m.', 'Stacja pomiarowa powyżej 1000 m n.p.m.'))
plt.xlabel("Szerokość geograficzna (N lub S)")
plt.ylabel("Średnia temperatura (stopnie Celsjusza)")
plt.title("Średnia temperatura w 2019 roku w zależności od szerokości geograficznej")
plt.show()

# show this as a 3D plot
fig = plt.figure()
plt.suptitle("Średnia temperatura w 2019 roku w zależności od szerokości geograficznej i wysokości n.p.m.")
ax = plt.axes(projection='3d')
ax.set_xlabel("Wysokość nad poziomem morza")
ax.set_ylabel("Szerokość geograficzna (N lub S)")
ax.set_zlabel("Średnia temperatura (stopnie Celsjusza)")
ax.scatter3D(low.elevation, low.latabs, low.avgtemp, label="Stacja pomiarowa poniżej 1000 m n.p.m.", c="blue")
ax.scatter3D(high.elevation, high.latabs, high.avgtemp, label="Stacja pomiarowa powyżej 1000 m n.p.m.", c="red")
ax.legend()
plt.show()

# show scatter plot with a regression line
sns.regplot(x="latabs", y="avgtemp", color="blue", data=landtemps)
plt.xlabel("Szerokość geograficzna (N lub S)")
plt.ylabel("Średnia temperatura (stopnie Celsjusza)")
plt.title("Średnia temperatura w 2019 roku w zależności od szerokości geograficznej")
plt.show()

# show scatter plot with different regression lines by elevation group
landtemps['elevation_group'] = np.where(landtemps.elevation<=1000,'low','high')
sns.lmplot(x="latabs", y="avgtemp", hue="elevation_group", palette=dict(low="blue", high="red"), legend_out=False, data=landtemps)
plt.xlabel("Szerokość geograficzna (N lub S)")
plt.ylabel("Średnia temperatura (stopnie Celsjusza)")
plt.legend(('Stacja pomiarowa poniżej 1000 m n.p.m.', 'Stacja pomiarowa powyżej 1000 m n.p.m.'), loc='lower left')
plt.yticks(np.arange(-60, 40, step=20))
plt.title("Średnia temperatura w 2019 roku w zależności od szerokości geograficznej")
plt.tight_layout()
plt.show()

# check some average temperatures above the regression lines
high.loc[(high.latabs>38) & (high.avgtemp>=18),
  ['station','country','latabs','elevation','avgtemp']]
low.loc[(low.latabs>47) & (low.avgtemp>=14),
  ['station','country','latabs','elevation','avgtemp']]

# check some average temperatures below the regression lines
high.loc[(high.latabs<5) & (high.avgtemp<18),
  ['station','country','latabs','elevation','avgtemp']]
low.loc[(low.latabs<50) & (low.avgtemp<-9),
  ['station','country','latabs','elevation','avgtemp']]

