# import pandas, numpy, and matplotlib
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import seaborn as sns
pd.set_option('display.width', 80)
pd.set_option('display.max_columns', 7)
pd.set_option('display.max_rows', 200)
pd.options.display.float_format = '{:,.0f}'.format
nls97 = pd.read_csv("dane/nls97.csv")
nls97.set_index("personid", inplace=True)
covidtotals = pd.read_csv("dane/covidtotals.csv", parse_dates=["lastdate"])

covidtotals.set_index("iso_code", inplace=True)

# do a violin plot of sat verbal scores
sns.violinplot(y=nls97.satverbal, color="wheat")
plt.title("Wyniki z części humanistycznej egzaminu SAT")
plt.ylabel("SAT - część humanistyczna")
plt.text(0.08, 780, 'Próg wartości odstających', horizontalalignment='center', size='x-small')
plt.text(0.065, nls97.satverbal.quantile(0.75), 'Trzeci kwartyl', horizontalalignment='center', size='x-small')
plt.text(0.05, nls97.satverbal.median(), 'Mediana', horizontalalignment='center', size='x-small')
plt.text(0.065, nls97.satverbal.quantile(0.25), 'Pierwszy kwartyl', horizontalalignment='center', size='x-small')
plt.text(0.08, 210, 'Próg wartości odstających', horizontalalignment='center', size='x-small')
plt.text(-0.4, 500, 'Częstość', horizontalalignment='center', size='x-small')
plt.show()

# get some descriptives
nls97.loc[:, ['weeksworked16','weeksworked17']].describe()

# show weeks worked for 2016 and 2017
myplt = sns.violinplot(data=nls97.loc[:, ['weeksworked16','weeksworked17']])
myplt.set_title("Wykres skrzypcowy liczby przepracowanych tygodni")
myplt.set_xticklabels(["Liczba tygodni przepracowanych w 2016 roku","Liczba tygodni przepracowanych w 2017 roku"])
plt.show()

# do a violin plot of wage income by gender
nls97["maritalstatuscollapsed"] = nls97.maritalstatus.\
  replace(['Married','Never-married','Divorced','Separated','Widowed'],\
  ['Małżeństwo','Wolny','Rozwód/Separacja/Wdowieństwo','Wolny','Wolny'])
nls97["gender"] = nls97["gender"].replace(['Female', 'Male'],['Mężczyzna', 'Kobieta'])
sns.violinplot(nls97.gender, nls97.wageincome, hue=nls97.maritalstatuscollapsed, scale="count")
plt.title("Zarobki w zależności od płci i stanu cywilnego")
plt.xlabel('Płeć')
plt.ylabel('Przychód w 2017 roku')
plt.legend(title="", loc="upper center", framealpha=0, fontsize=8)
plt.tight_layout()
plt.show()

# do a violin plot of weeks worked by degree attainment
nls97 = nls97.sort_values(['highestdegree'])
myplt = sns.violinplot('highestdegree','weeksworked17', data=nls97)
xticklabels = ['0. Brak', '1. Podstawowe', '2. Średnie', '3. Policealne', '4. Licencjat', '5. Magister', '6. Doktor', '7. Profesor']
myplt.set_xticklabels(xticklabels, rotation=60, horizontalalignment='right')
myplt.set_title("Liczba przepracowanych tygodni w zależności od wykształcenia")
myplt.set_xlabel('Wykształcenie')
myplt.set_ylabel('Liczba tygodni przepracowanych w 2017 roku')
plt.tight_layout()
plt.show()

