# import pandas
import pandas as pd
pd.options.display.float_format = '{:,.2f}'.format
pd.set_option('display.width', 200)

# import the land temperature data
landtemps = pd.read_csv('dane/landtemps.zip', compression='zip',
    names=['ID_stacji','rok','miesiąc','średnia_temperatura','szerokość_geograficzna',
      'długość_geograficzna','wysokość','stacja','ID_państwa','nazwa_państwa'],
    skiprows=1,
    parse_dates=[['miesiąc','rok']],
    low_memory=False)

type(landtemps)

# show enough data to get a sense of how the import went
landtemps.head(7)
landtemps.sample(7)
landtemps.dtypes
landtemps.shape
landtemps[['średnia_temperatura']].describe()

# remove rows with missing values
landtemps.dropna(subset=['średnia_temperatura'], inplace=True)
landtemps.head(7)
landtemps.shape

