// "C++. wiczenia zaawansowane", Andrzej Stasiewicz, Helion 2004

#include <iostream>
using namespace std;

class Figura
{
 public:
    int kolor;
    Figura( void) : kolor( 0)
    {
     cout << "   Figura - konstruktor domyslny" << endl;
    }
    explicit Figura( int Akolor) : kolor( Akolor)
    {
     cout << "   Figura - konstruktor merytoryczny" << endl;
    }
    Figura( const Figura &f) : kolor( f.kolor)
    {
     cout << "   Figura - konstruktor kopiujacy" << endl;
    }
    Figura & operator = ( const Figura &f)
    {
     if( this != &f)
     {
        cout << "   Figura - operator przypisania" << endl;
        kolor = f.kolor;
     }
     return *this;
    }
    ~Figura()
    {
        cout << "   Figura - destruktor" << endl;
    }
};
//------------------------------------------------
class Kwadrat : public Figura
{
 public:
    int wymiar;
    Kwadrat( void) : Figura(), wymiar( 3)
    { 
     cout << "   Kwadrat - konstruktor domyslny" << endl;
    }
    Kwadrat( int kolor, int Awymiar) : Figura( kolor), wymiar( Awymiar)
    { 
     cout << "   Kwadrat - konstruktor merytoryczny" << endl;
    }
    Kwadrat( const Kwadrat &k) : Figura( k), wymiar( k.wymiar)
    { 
     cout << "   Kwadrat - konstruktor kopiujacy" << endl;
    }
    Kwadrat & operator = ( const Kwadrat &k)
    {
     if( this != &k)
     {
        Figura :: operator=( k);
        cout << "   Kwadrat - operator przypisania" << endl;
        wymiar = k.wymiar;
     }
     return *this;
    }
    ~Kwadrat()
    {
        cout << "   Kwadrat - destruktor" << endl;
    }
    void wypisz( void)
    {
     cout << "   [kolor = " << kolor << ", wymiar = " << wymiar << "]" << endl;
    }
};
//------------------------------------------------
int main()
{
 cout << "Deklarowanie dynamicznej tablicy kwadratow ..." << endl;
 Kwadrat *adr = new Kwadrat[ 3];
 cout << endl << "Usuwanie kwadratow za pomoca destruktorow ..." << endl;
 delete [] adr;
 char c;
 cin >> c;
}

