// "C++. wiczenia zaawansowane", Andrzej Stasiewicz, Helion 2004

#include <iostream>
using namespace std;

class Figura
{
 public:
    int kolor;
    Figura( void) : kolor( 0)
    {
     cout << "   Figura - konstruktor domyslny" << endl;
    }
    explicit Figura( int Akolor) : kolor( Akolor)
    {
     cout << "   Figura - konstruktor merytoryczny" << endl;
    }
    Figura( const Figura &f) : kolor( f.kolor)
    {
     cout << "   Figura - konstruktor kopiujacy" << endl;
    }
    Figura & operator = ( const Figura &f)
    {
     if( this != &f)
     {
        cout << "   Figura - operator przypisania" << endl;
        kolor = f.kolor;
     }
     return *this;
    }
    ~Figura()
    {
        cout << "   Figura - destruktor" << endl;
    }
    virtual void rysuj( void)
    {
        cout << "   ***** Figura - rysowanie *****" << endl;
    }
};
//------------------------------------------------
class Kwadrat : public Figura
{
 public:
    int wymiar;
    Kwadrat( void) : Figura(), wymiar( 3)
    { 
     cout << "   Kwadrat - konstruktor domyslny" << endl;
    }
    Kwadrat( int kolor, int Awymiar) : Figura( kolor), wymiar( Awymiar)
    { 
     cout << "   Kwadrat - konstruktor merytoryczny" << endl;
    }
    Kwadrat( const Kwadrat &k) : Figura( k), wymiar( k.wymiar)
    { 
     cout << "   Kwadrat - konstruktor kopiujacy" << endl;
    }
    Kwadrat & operator = ( const Kwadrat &k)
    {
     if( this != &k)
     {
        Figura :: operator=( k);
        cout << "   Kwadrat - operator przypisania" << endl;
        wymiar = k.wymiar;
     }
     return *this;
    }
    ~Kwadrat()
    {
        cout << "   Kwadrat - destruktor" << endl;
    }
    void wypisz( void)
    {
     cout << "   [kolor = " << kolor << ", wymiar = " << wymiar << "]" << endl;
    }
    void rysuj( void)
    {
        cout << "   ***** Kwadrat - rysowanie *****" << endl;
    }
};
//------------------------------------------------
int main()
{
 cout << "Deklarowanie figury ..." << endl;
 Figura f;
 f.rysuj();
 cout << "Deklarowanie kwadratu ..." << endl;
 Kwadrat k;
 k.rysuj();
 char c;
 cin >> c;
}

