#!/bin/sh
# Uruchamiać z prawami administratora (jako root)
# Adresy IP serwera administracyjnego (ADMIN_IP) i komputera objętego kwarantanną (SERVER_IP)
ADMIN_IP="X"
SERVER_IP="Y"
# Wyczyszczenie bieżących reguł
iptables -F
iptables -X
# Dodanie serwera administracyjnego do listy adresów dozwolonych 
iptables -A INPUT -s $ADMIN_IP -j ACCEPT
iptables -A OUTPUT -d $ADMIN_IP -j ACCEPT
# Ustawienie domyślnych zasad filtrowania 
iptables -P INPUT DROP
iptables -P OUTPUT DROP
iptables -P FORWARD DROP
# Dopuszczenie ruchu w obrębie lokalnego hosta 
iptables -A INPUT -i lo -j ACCEPT
iptables -A OUTPUT -o lo -j ACCEPT
# Dopuszczenie komunikacji SSH tylko z serwerem administracyjnym 
iptables -A INPUT -p tcp -s $ADMIN_IP -d $SERVER_IP --sport 513:65535 --dport 22 -m state --state NEW,ESTABLISHED -j ACCEPT
iptables -A OUTPUT -p tcp -s $SERVER_IP -d $ADMIN_IP --sport 22 --dport 513:65535 -m state --state ESTABLISHED -j ACCEPT
# Usuwanie wszelkiego innego ruchu sieciowego i zapisanie reguł
iptables -A INPUT -j DROP
iptables -A OUTPUT -j DROP
iptables-save
