// Uniwersalny program rejestrujący wpisy do dziennika
package main 
import (
    "fmt"
    "os"
    "os/user"
    "os/exec"
    "time"
    "io/ioutil"

)
  
func main() {
  
  //Przygotowanie zmiennych
  logFile := "log.txt";
  hostName, _ := os.Hostname();
  user, _ := user.Current();
  programName := os.Args[0];
  
  //Sprawdzenie czy istnieje program zapasowy?
  backStatus := "program zapasowy jest obecny";
  if !Exists(programName+".bak") { backStatus = "brak programu zapasowego"; }
  
  //Obszar powiadamiania
  notification := fmt.Sprintf("%s: Użytkownik %s uruchamia %s na %s i %s \n", time.Now(), user.Username, programName, hostName, backStatus);
  //Wysłanie lub zapisanie powiadomienia 
  //fmt.Println(notification);
  err := WriteFile(notification, logFile);
 
  //Wykonanie
  results, _ := RunCommand(programName+".bak", os.Args[1:]);
  
  //Przesłanie wyników do użytkownika
  fmt.Println(results);
}

func RunCommand(cmd string, args []string) (string, error) {
  out, err := exec.Command(cmd, args...).CombinedOutput()
  if err != nil {
    return string(out), err
  }
  return string(out), nil
}

func Exists(path string) bool {
  //Pobranie informacji o pliku
  _, err := os.Stat(path)
  //Jeżeli nie stwierdzono problemów, to plik istnieje
  if err == nil {
    return true
  }
  //Jeżeli pobieranie informacji się nie powiodło, to plik nie istnieje
  return false
}

func WriteFile(text, logfile string) (error) {
  //Weryfikacja, czy plik dziennika już istnieje, aby wybrać utworzenie nowego lub dopisywanie
  if Exists(logfile) {
    //Zapis linii do pliku 
    f, err := os.OpenFile(logfile,
    os.O_APPEND|os.O_CREATE|os.O_WRONLY, 0644)
    if err != nil {
      return err
    }
    defer f.Close()
    if _, err := f.WriteString(text); err != nil {
      return err
    }  
  } else {
    //Utworzenie pliku i zapisanie pierwszych linii
    err := ioutil.WriteFile(logfile, []byte(text), 0700)
    if err != nil {
      return err
    }
  }
  return nil
}
