import sys  
import time
import logging
import hashlib
import subprocess
# Komentarz 1: Importowanie istotnych elementów biblioteki obserwacji plików lub folderów Watchdog 
from watchdog  .observers import Observer 
from watchdog.events import LoggingEventHandler
# Komentarz 2: Konfiguracja wyjściowego pliku dziennika zdarzeń
logging.basicConfig(filename="file_integrity.txt",
                    filemode='a',
                    level=logging.INFO,
                    format='%(asctime)s - %(message)s',
                    datefmt='%Y-%m-%d %H:%M:%S')
hasher = hashlib.sha1()

def main():
  path = input("Podaj ścieżkę do monitorowanego katalogu: ")
  # Komentarz 3: Uruchomienie metody obsługi zdarzeń oraz metody obserwatora katalogu docelowego
  event_handler = LoggingEventHandler()
  event_handler.on_created = on_created
  observer = Observer()
  observer.schedule(event_handler, path, recursive=True)
  observer.start()
  try:
    while True:
      time.sleep(1)
  except KeyboardInterrupt:
    observer.stop()
  observer.join()

def on_created(event):
  # Komentarz 4: Akcje do wykonania gdy nowy plik zostanie zapisany
  subprocess.Popen(['chattr', '+i', event.src_path], bufsize=1)
  with open(event.src_path, 'rb') as afile:
    buf = afile.read()
    hasher.update(buf)
  logging.info(f"Artifact: %s \nFile SHA1: %s\n", event.src_path, hasher.hexdigest())
  print("Utworzono nowy plik: {}\n Skrót SHA1: {}\n".format(event.src_path, hasher.hexdigest()))

if __name__ == "__main__":
  main() 
