#!/bin/bash -
#
# Rapid Cybersecurity Ops
# vtjson.sh
#
# Opis:
# Przeszukuje plik JSON pod kątem szkodliwego oprogramowania wykrytego przez VirusTotal 
#
# Użycie:
# vtjson.awk [<plik json>] 
#   <plik json> Plik zawierający wyniki z narzędzia VirusTotal 
#           domyślnie: Calc_VirusTotal.txt
#

RE='^.(.*)...\{.*detect..(.*),..vers.*result....(.*).,..update.*$'     # <1>

FN="${1:-Calc_VirusTotal.txt}"
sed -e 's/{"scans": {/&\n /' -e 's/},/&\n/g' "$FN" |           # <2>
while read ALINE
do
    if [[ $ALINE =~ $RE ]]                                     # <3>
    then
	VIRUS="${BASH_REMATCH[1]}"                                    # <4>
	FOUND="${BASH_REMATCH[2]}"
	RESLT="${BASH_REMATCH[3]}"
	if [[ $FOUND =~ .*true.* ]]                                   # <5>
	then
	    echo $VIRUS "- result:" $RESLT
	fi
    fi
done
