#!/bin/bash

# Opis:
# Tworzy listę odniesienia w systemie lub porównuje bieżący stan
# systemu plików z poprzednią listą odniesienia 
#

function usageErr ()
{
    echo 'użycie: baseline.sh [-d path] file1 [file2]'
    echo 'tworzy lub porównuje plik odniesienia określony ścieżką'
    echo 'domyślną ścieżką jest /'
    exit 2
} >&2                                                          # <1>

function dosumming ()
{
    find "${DIR[@]}" -type f | xargs -d '\n' sha1sum           # <2>
}

# ===============================
# MAIN
# ===============================

declare -a DIR

# ---------- parsowanie argumentów 

while getopts "d:" MYOPT                                   # <3>
do
    # nie sprawdzamy wartości MYOPT, ponieważ jest tylko jeden wybór
    DIR+=( "$OPTARG" )                                     # <4>
done
shift $((OPTIND-1))                                        # <5>

# brak argumentów? za dużo?
(( $# == 0 || $# > 2 )) &&  usageErr 

(( ${#DIR[*]} == 0 )) && DIR=( "/" )                       # <6>


# tworzymy plik odniesienia (podana jest tylko jedna ścieżka do pliku)
# lub drugie podsumowanie (gdy podane są dwie ścieżki do pliku)

BASE="$1"
B2ND="$2"

if (( $# == 1 ))    # tylko 1 argument
then
    # tworzenie "$BASE"
    dosumming > "$BASE" 
    # wszystko jest gotowe dla punktu odniesienia
    exit
fi

if [[ ! -r "$BASE" ]]
then
    usageErr
fi

# --------- główne zadanie:

# jeśli istnieje drugi plik, porównujemy obydwa pliki 
# w przeciwnym razie tworzymy i wypełniamy nowy plik
if [[ ! -e "$B2ND" ]]
then
    echo creating "$B2ND"
    dosumming > "$B2ND"
fi

# obecnie mamy: 2 pliki utworzone poleceniem sha1sum
declare -A BYPATH BYHASH INUSE 	# tablice asocjacyjne

# wczytujemy pierwszy plik jako plik odniesienia
while read HNUM FN
do
    BYPATH["$FN"]=$HNUM
    BYHASH[$HNUM]="$FN"
    INUSE["$FN"]="X"
done < "$BASE"

# ------ zaczynamy tworzenie wyników
# sprawdzamy, czy wszystkie nazwy plików w drugim pliku znajdują się 
# w tym samym miejscu (ścieżka) jak w pierwszym pliku (punkt odniesienia)

printf '<filesystem host="%s" dir="%s">\n' "$HOSTNAME"  "${DIR[*]}"

while read HNUM FN					# <7>
do
    WASHASH="${BYPATH[${FN}]}"
    # czy znaleziono pasującą ścieżkę? jeśli nie, będzie mieć wartość null
    if [[ -z $WASHASH ]]
    then
	ALTFN="${BYHASH[$HNUM]}"
	if [[ -z $ALTFN ]]
	then
	    printf '  <new>%s</new>\n' "$FN"
	else
	    printf '  <relocated orig="%s">%s</relocated>\n' "$ALTFN" "$FN"
	    INUSE["$ALTFN"]='_'	# oznaczamy jako sprawdzone
	fi
    else
	INUSE["$FN"]='_'	# oznaczamy jako sprawdzone
	if [[ $HNUM == $WASHASH ]]
	then
	    continue;		# nic się nie zmieniło;
	else
	    printf '  <changed>%s</changed>\n' "$FN"
	fi
    fi
done < "$B2ND"                                          # <8>

for FN in "${!INUSE[@]}"
do
    if [[ "${INUSE[$FN]}" == 'X' ]]
    then
        printf '  <removed>%s</removed>\n' "$FN"
    fi
done

printf '</filesystem>\n'

