#!/bin/bash -
#
# Operacje cyberbezpieczeństwa w bashu
# bannergrabber.sh
#
# Opis:
# Automatycznie pobiera banery z serwerów HTTP, SMTP i FTP 
#
# Użycie: ./bannergrabber.sh nazwahosta [pliktymczasowy] 
#   pliktymczasowy jest używany podczas przetwarzania, ale potem jest usuwany;
#   domyślnie jest to plik "scratch.file" lub o nazwie wygenerowanej poleceniem tempfile
#

#
function isportopen ()
{
    (( $# < 2 )) && return 1                           # <1>
    local host port
    host=$1
    port=$2
    echo >/dev/null 2>&1  < /dev/tcp/${host}/${port}   # <2>
    return $?
}

function cleanup ()
{
    rm -f "$SCRATCH"
}

ATHOST="$1"
SCRATCH="$2"
if [[ -z $2 ]]
then
    if [[ -n $(type -p tempfile) ]]
    then
	SCRATCH=$(tempfile)
    else
    	SCRATCH='scratch.file'
    fi
fi

trap cleanup EXIT                                      # <3>
touch "$SCRATCH"                                       # <4>

if isportopen $ATHOST 21	# FTP                  <5>
then
    # np. ftp -n $ATHOST 
    exec 3<>/dev/tcp/${ATHOST}/21                      # <6>
    echo -e 'quit\r\n' >&3                             # <7>
    cat <&3  >> "$SCRATCH"                             # <8>
fi

if isportopen $ATHOST 25	# SMTP
then
    # np. telnet $ATHOST 25 
    exec 3<>/dev/tcp/${ATHOST}/25
    echo -e 'quit\r\n' >&3
    cat <&3  >> "$SCRATCH"
fi

if isportopen $ATHOST 80	# HTTP
then
    curl -LIs "https://${ATHOST}"  >> "$SCRATCH"      # <9>
fi

cat "$SCRATCH"                                        # <10>

