#!/bin/bash -
#
# Rapid Cybersecurity Ops
# webdash.sh
#
# Opis:
# Tworzenie pulpitu informacyjnego
# Nagłówek
# --------------
# 1 wiersz wyników                                  
# --------------
# 5 wierszy wyników
# ...                                           
# --------------
# etykiety kolumn, a następnie 
# 8 wierszy histogramów
# ...
# -------------- 
#
    
# kilka ważnych stałych ciągów tekstowych
UPTOP=$(tput cup 0 0)                               # <1>
ERAS2EOL=$(tput el)
REV=$(tput rev)		# odwrócenie wideo
OFF=$(tput sgr0)	# ogólny reset
SMUL=$(tput smul)	# włączenie trybu podkreślania
RMUL=$(tput rmul)	# wyłączenie trybu podkreślania (reset)
COLUMNS=$(tput cols)	# szerokość okna 
# DASHES='------------------------------------'
printf -v DASHES '%*s' $COLUMNS '-'                 # <2>
DASHES=${DASHES// /-}

#
# prSection - wyświetla sekcję ekranu 
# wyświetla tyle wierszy ze strumienia stdin, ile wynosi wartość zmiennej $1
# każdy wiersz jest wypełniony tekstem, 
# na końcu którego znajdują się znaki czyszczenia wiersza 
# sekcje kończą się linią kresek
#
function prSection ()
{
    local -i i					    # <3>
    for((i=0; i < ${1:-5}; i++))
    do
        read aline
        printf '%s%s\n' "$aline" "${ERAS2EOL}"	    # <4>
    done
    printf '%s%s\n%s' "$DASHES" "${ERAS2EOL}" "${ERAS2EOL}"
}

function cleanup()				    # <5>
{
    if [[ -n $BGPID ]] 
    then
      kill %1					    # <6>
      rm -f $TMPFILE
    fi
} &> /dev/null					    # <7>

trap cleanup EXIT 

# uruchamia proces w tle
TMPFILE=$(tempfile)                                 # <8>
{ bash tailcount.sh $1 | \
  bash livebar.sh > $TMPFILE ; } &                  # <9>
BGPID=$!

clear
while true
do
    printf '%s' "$UPTOP"
    # nagłówek:
    echo "${REV}Operacje cyberbezpieczeństwa r. 12. -- Pulpit zabezpieczeń${OFF}" \
    | prSection 1
    #----------------------------------------
    {                                               # <10>
      printf 'połączenia:%4d        %s\n' \
            $(netstat -an | grep 'ESTAB' | wc -l) "$(date)" 
    } | prSection 1
    #----------------------------------------
    tail -5 /var/log/system.log | cut -c 1-16,45-105 | prSection 5 
    #----------------------------------------
    { echo "${SMUL}yymmdd${RMUL}"    \
            "${SMUL}hhmmss${RMUL}"  \
            "${SMUL}liczba zdarzeń${RMUL}"
      tail -8 $TMPFILE 
    } | prSection 9
    sleep 3
done
