#!/bin/bash -
#
# Operacje cyberbezpieczeństwa w bashu
# fd2.sh
#
# Opis:
# Porównuje dwa wyniki skanowania portów w celu znalezienia zmian 
# ISTOTNE ZAŁOŻENIE: obydwa pliki zawierają tyle samo wierszy, 
# a w każdym wierszu znajduje się ten sam adres hosta
# chociaż wymienione porty mogą być inne 
#
# Użycie: ./fd2.sh <plik1> <plik2>
#
                    
# szuka "$LOOKFOR" na liście argumentów tej funkcji 
# zwraca true (0) jeśli tej wartości nie ma na liście
function NotInList ()                                            # <1>
{
    for port in "$@"
    do
        if [[ $port == $LOOKFOR ]]
        then
            return 1
        fi
    done
    return 0
}

while true
do
    read aline <&4 || break         # w EOF                  # <2>
    read bline <&5 || break         # w EOF dla symetrii     # <3>

    # if [[ $aline == $bline ]] ; then continue; fi
    [[ $aline == $bline ]] && continue;                       # <4>

    # znaleziono różnicę, a zatem 
    # dzielimy ją na hosta i porty
    HOSTA=${aline%% *}                                        # <5>
    PORTSA=( ${aline#* } )                                    # <6>

    HOSTB=${bline%% *}
    PORTSB=( ${bline#* } )

    echo $HOSTA                 # identyfikujemy zmienione hosty

    for porta in ${PORTSA[@]}
    do         # <7>
          LOOKFOR=$porta NotInList ${PORTSB[@]} && echo "  closed: $porta"
    done

    for portb in ${PORTSB[@]}
    do
          LOOKFOR=$portb NotInList ${PORTSA[@]} && echo "     new: $portb"
    done

done 4< ${1:-day1.data} 5< ${2:-day2.data}                   # <8>
# day1.data i day2.data są domyślnymi nazwami, ułatwiającymi testowanie
