#!/bin/bash -
#
# Operacje cyberbezpieczeństwa w bashu
# livebar.sh
#
# Opis:
# Tworzy odświeżalny poziomy wykres słupkowy na podstawie dynamicznych danych
#
# Użycie:
# <wyniki innego skryptu lub programu> | bash livebar.sh
#

function pr_bar ()					# <1>
{
    local raw maxraw scaled
    raw=$1
    maxraw=$2
    ((scaled=(maxbar*raw)/maxraw))
    ((scaled == 0)) && scaled=1		# gwarancja minimalnego rozmiaru
    for((i=0; i<scaled; i++)) ; do printf '#' ; done
    printf '\n'
    
} # pr_bar


maxbar=60   # największa liczba znaków w pasku		# <2>
MAX=60
while read dayst timst qty
do
    if (( qty > MAX ))					# <3>
    then
	let MAX=$qty+$qty/4	# dodajemy pewien margines
	echo "              **** przeskalowanie: MAX=$MAX"
    fi
    printf '%6.6s %6.6s %4d:' $dayst $timst $qty	# <4>
    pr_bar $qty $MAX
done
