#!/bin/bash -
#
# Operacje cyberbezpieczeństwa w bashu
# histogram.sh
#
# Opis:
# Generowanie poziomego wykresu słupkowego na podstawie podanych danych 
#
# Użycie: ./histogram.sh
#   format wejściowy: etykieta wartość
#

function pr_bar ()                            # <1>
{
    local -i i raw maxraw scaled              # <2>
    raw=$1
    maxraw=$2
    ((scaled=(MAXBAR*raw)/maxraw))            # <3>
    # gwarancja minimalnego rozmiaru
    ((raw > 0 && scaled == 0)) && scaled=1				# <4>

    for((i=0; i<scaled; i++)) ; do printf '#' ; done
    printf '\n'
    
} # pr_bar

#
# "main"
#
declare -A RA						# <5>
declare -i MAXBAR max
max=0
MAXBAR=50	# wielkość najdłuższego słupka

while read labl val
do
    let RA[$labl]=$val					# <6>
    # zachowujemy największą wartość w celu skalowania
    (( val > max )) && max=$val
done

# skalujemy i wyświetlamy
for labl in "${!RA[@]}"					# <7>
do
    printf '%-20.20s  ' "$labl"
    pr_bar ${RA[$labl]} $max				# <8>
done
