#!/bin/bash -
#
# Operacje cyberbezpieczeństwa w bashu
# scan.sh
#
# Opis:
# Skanuje porty określonego hosta 
#
# Użycie: ./scan.sh <plik wyjściowy>
#   <plik wyjściowy> Plik, w którym należy zapisać wyniki
#

function scan ()
{
  host=$1
  printf '%s' "$host"                                       # <1>
  for ((port=1;port<1024;port++))
  do
    # kolejność przekierowań jest ważna z dwóch powodów
    echo >/dev/null 2>&1  < /dev/tcp/${host}/${port}        # <2>
    if (($? == 0)) ; then printf ' %d' "${port}" ; fi       # <3>
  done
  echo # or printf '\n'
}

#
# główna pętla    
#   wczytuje wszystkie nazwy hostów (ze strumienia stdin)
#   i skanuje je pod kątem otwartych portów
#   zapisuje wyniki w pliku,
#   którego nazwa jest podana w argumencie
#   lub domyślnie jest oparta na bieżącym dniu
#

printf -v TODAY 'scan_%(%F)T' -1   # np., scan_2017-11-27  # <4>
OUTFILE=${1:-$TODAY}                                        # <5>

while read HOSTNAME
do
    scan $HOSTNAME
done > $OUTFILE                                             # <6>
